//
//  SPBoxView.h
//  SamplePlugIn
//
//  Created by Kai on 11.1.08.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@class SPLinearGradient;

/*!
 SPBoxView is a container view with configurable background and borders.
 */

@interface SPBoxView : NSView <NSCoding>
{
	@private
		float					_cornerRadius;

		NSColor*				_fillColor;
		SPLinearGradient*	_gradient;
		
		NSColor*				_borderColor;
		float					_borderWidth;

		NSShadow*			_boxShadow;

		float					_leftInset;
		float					_topInset;
		float					_rightInset;
		float					_bottomInset;
		BOOL					_insetsAreValid;
}

// Accessors:

- (CGFloat) cornerRadius;
- (void) setCornerRadius:(CGFloat)value;

- (NSColor*) fillColor;
- (void) setFillColor:(NSColor*)value;

- (SPLinearGradient*) gradient;
- (void) setGradient:(SPLinearGradient*)value;

//- (CGFloat) gradiantAngle;
//- (void) setGradiantAngle:(CGFloat)value;

- (NSColor*) borderColor;
- (void) setBorderColor:(NSColor*)value;

- (CGFloat) borderWidth;
- (void) setBorderWidth:(CGFloat)value;

// Note: "shadow" is already used by NSView for the CA layer shadow.
- (NSShadow*) boxShadow;
- (void) setBoxShadow:(NSShadow*)value;

/*! Mark inset values as needing recalculation. */
- (void) invalidateInsets;

/*! Calculate inset values and cache them in the instance variable. */
- (void) calculateInsets;

@end
